
#ifndef SEP_ERROR_H
#define SEP_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object name     :  CRYS_error.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:55:47 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This module defines the error return code types and the numbering spaces of the error codes
   *         for each module of the layers listed below.
   *
   *  \version CRYS_error.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines ******************************/

/**
 * \brief The definitions of the error number space used for the different modules
 */

/* ........... Error base numeric mapping definitions ................... */
/* ----------------------------------------------------------------------- */
 
 /* The global error base number */
#define DX_SEP_ERROR_BASE          0x00A00000UL

///* The error range number assigned for each layer */
//#define DX_SEP_ERROR_LAYER_RANGE   0x00010000UL

/* The error range number assigned to each module on its specified layer */
#define DX_SEP_ERROR_MODULE_RANGE  0x00001000UL

///* Defines the layer index for the error mapping */
//#define CRYS_LAYER_ERROR_IDX  0UL
//#define LLF_LAYER_ERROR_IDX   1UL
//#define LLFCD_LAYER_ERROR_IDX 2UL
//#define VOS_LAYER_ERROR_IDX   3UL
//#define PLAT_LAYER_ERROR_IDX  4UL

/* Defines the module index for error mapping */
#define BOOT_ERROR_IDX        0x0UL
#define SEP_FLOW_ERROR_IDX    0x1UL
#define GEN_ERROR_IDX		  0x2UL
#define INT_ERROR_IDX		  0x3UL
#define LCS_ERROR_IDX         0x5UL
#define MCTR_ERROR_IDX        0x6UL
#define OTP_ERROR_IDX         0x7UL
#define MAIN_ERROR_IDX        0x8UL
#define PARSER_ERROR_IDX      0x9UL
#define SJTAG_ERROR_IDX       0xAUL
#define EXT_APP_ERROR_IDX      0xBUL




/* .......... defining the error spaces for each module on each layer ........... */
/* ------------------------------------------------------------------------------ */

/* BOOT module on the CRYS layer base address - 0x00A00000 */
#define DX_SEP_BOOT_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * BOOT_ERROR_IDX ) )  
                                    

/* FLOW module on the CRYS layer base address - 0x00A01000 */
#define DX_SEP_FLOW_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * SEP_FLOW_ERROR_IDX ) )  
                                    

/* GEN module on the CRYS layer base address - 0x00A02000 */
#define DX_SEP_GEN_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * GEN_ERROR_IDX ) )  

/* INT module on the CRYS layer base address - 0x00A03000 */
#define DX_SEP_INT_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * INT_ERROR_IDX ) )  

/* LCS module on the CRYS layer base address - 0x00A05000 */
#define DX_SEP_LCS_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * LCS_ERROR_IDX ) )  

/* MONO CTR module on the CRYS layer base address - 0x00A06000 */
#define DX_SEP_MCTR_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * MCTR_ERROR_IDX ) )  

/* OTP module on the CRYS layer base address - 0x00A07000 */
#define DX_SEP_OTP_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * OTP_ERROR_IDX ) )  

/* MAIN module on the CRYS layer base address - 0x00A08000 */
#define DX_SEP_MAIN_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * MAIN_ERROR_IDX ) )  

/* PARSER module on the CRYS layer base address - 0x00A09000 */
#define DX_SEP_PARSER_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * PARSER_ERROR_IDX ) )  

/* SJTAG module on the CRYS layer base address - 0x00A0A000 */
#define DX_SEP_SJTAG_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * SJTAG_ERROR_IDX ) )  
                    
/* EXT application base address - 0x00A0B000 */
#define DX_SEP_EXT_APP_MODULE_ERROR_BASE  (DX_SEP_ERROR_BASE + \
                                     (DX_SEP_ERROR_MODULE_RANGE * EXT_APP_ERROR_IDX ) )  
                    
                    
/* ............ The OK (success) definition ....................... */
#define DX_SEP_OK 0                         
                                                                                                            
/************************ Enums ********************************/


/************************ Typedefs  ****************************/

/**
 * \brief The typedef definition of all of the error codes that are returned from the CRYS functions 
 */
 

/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif




